package cn.com.duiba.kjy.paycenter.api.remoteservice.config;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.config.UnionpayFpsdMchConfDto;
import cn.com.duiba.kjy.paycenter.api.param.PageQuery;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2022/10/26 10:46 上午
 **/
@AdvancedFeignClient
public interface RemoteUnionpayFpsdMchConfService {
    /**
     * 分页查询
     * @param pageQuery 查询条件
     * @return 银联聚分期商户配置集合
     */
    List<UnionpayFpsdMchConfDto> selectPage(PageQuery pageQuery);

    /**
     * 根据条件,查询记录的总记录数
     * @return 符合条件的记录数
     */
    Long selectCount();

    /**
     * 根据主键查询
     * @param id 主键
     * @return 银联聚分期商户配置
     */
    UnionpayFpsdMchConfDto selectById(Long id);

    /**
     * 新增
     * @param dto 银联聚分期商户配置
     * @return 执行结果
     */
    int insert(UnionpayFpsdMchConfDto dto);

    /**
     * 更新
     * @param dto 银联聚分期商户配置
     * @return 执行结果
     */
    int update(UnionpayFpsdMchConfDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
