package cn.com.duiba.kjy.paycenter.api.dto.psbc;

import lombok.Data;

import java.io.Serializable;

/**
 * 邮储银行支付参数
 *
 * @author wangguanhua
 */
@Data
public class PsbcPayParam implements Serializable {

    private static final long serialVersionUID = 5116439022990583471L;

    /**
     * 订单号
     */
    private String termSsn;

    /**
     * 商户号
     */
    private String mercCode;

    /**
     * 交易金额（保留两位小数）
     */
    private String tranAmt;

    /**
     * 商户通知地址（回调接口，用于修改订单状态）
     */
    private String mercUrl;

    /**
     * 三方标识（服务商首字母大写缩写,例：蓝色兄弟：‘LSXD’）
     */
    private String psbcmcc;

    /**
     * 服务商页订单详情页url（用于支付成功页跳转）
     */
    private String backLink;

    /**
     * 订单日期（yyyy-MM-dd）
     */
    private String txnDt;

    @Override
    public String toString() {
        return "TermSsn=" + termSsn + "|MercCode=" + mercCode + "|TranAmt=" + tranAmt + "|MercUrl=" + mercUrl + "|psbcmcc=" + psbcmcc + "|BackLink=" + backLink + "|TxnDt=" + txnDt;
    }

}