package cn.com.duiba.kjy.paycenter.api.dto.unionpay;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 银联聚分期类型退款
 * @author kjj mybatis generator 
 * @date 2022-10-26
 */
@Data
public class RefundOrderUnionpayFpsdDto implements Serializable {
     
    private static final long serialVersionUID = 16667528764903933L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 银联聚分期商户id
     */
    private String svcId;

    /**
     * 退款商户订单号
     */
    private String mchntOrderId;

    /**
     * 退货金额,分为单位
     */
    private Integer transAt;

    /**
     * 原始支付商户订单号
     */
    private String orgnMchntOrderId;

    /**
     * 原始支付交易平台订单号,tb_charge_order_unionpay_fpsd.order_id
     */
    private String orgnOrderId;

    /**
     * 原交易总金额,分为单位
     */
    private Integer orgnTransAt;

    /**
     * 退款平台订单号,tb_charge_order_unionpay_fpsd.order_id
     */
    private String orderId;

    /**
     * 交易状态,00-交易成功,01-交易处理中,03-交易处理失败
     */
    private String transSt;

    /**
     * 结果码
     */
    private String respCode;

    /**
     * 结果描述
     */
    private String respMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}