/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.paycenter.api.enums;

import cn.com.duiba.kjy.paycenter.api.enums.PayTypeEnum;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum ChannelTypeEnum {
    WX_PUB("wx_pub", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8", PayTypeEnum.WX_PAY.getType()),
    WX_LITE("wx_lite", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8", PayTypeEnum.WX_PAY.getType()),
    ALIPAY_WAP_PAY("alipay_wap_pay", "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed82.0", PayTypeEnum.ALIPAY.getType()),
    UNION_PAY_FQSD("union_pay_fqsd", "\u94f6\u8054\u8da3\u5206\u671f", PayTypeEnum.UNION_PAY.getType()),
    CITIC_PAY("citic_pay", "\u4e2d\u4fe1\u5168\u4ed8\u901a", PayTypeEnum.CITIC_PAY.getType()),
    CCB_PAY("ccb_pay", "\u5efa\u884c\u6570\u5e01H5\u652f\u4ed8", PayTypeEnum.CCB_PAY.getType()),
    ALIPAY_FACE_TO_FACE_JSAPI("alipay_ftf_jsapi", "\u652f\u4ed8\u5b9d\u5f53\u9762\u4ed8", PayTypeEnum.ALIPAY.getType()),
    MINSHENG_PAY("minsheng_pay", "\u6c11\u751f\u94f6\u884cH5\u652f\u4ed8", PayTypeEnum.MINSHENG_PAY.getType()),
    HZ_BANK_PAY("hz_bank_pay", "\u676d\u5dde\u94f6\u884c\u652f\u4ed8", PayTypeEnum.HZ_BANK_PAY.getType());

    private final String channelType;
    private final String channelName;
    private final Integer payType;
    private static final Map<String, ChannelTypeEnum> ENUM_MAP;

    public static ChannelTypeEnum getByChannelType(String channelType) {
        if (channelType == null) {
            return null;
        }
        return ENUM_MAP.get(channelType);
    }

    public static boolean isActive(String channelType) {
        if (StringUtils.isBlank((String)channelType)) {
            return false;
        }
        return ChannelTypeEnum.getByChannelType(channelType) != null;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public Integer getPayType() {
        return this.payType;
    }

    private ChannelTypeEnum(String channelType, String channelName, Integer payType) {
        this.channelType = channelType;
        this.channelName = channelName;
        this.payType = payType;
    }

    static {
        ENUM_MAP = new HashMap<String, ChannelTypeEnum>();
        for (ChannelTypeEnum typeEnum : ChannelTypeEnum.values()) {
            ENUM_MAP.put(typeEnum.getChannelType(), typeEnum);
        }
    }
}

