package cn.com.duiba.kjy.paycenter.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Map;

/**
 * 支付通知rpc
 * @author lyj
 */
@AdvancedFeignClient
public interface RemoteNotifyService {

    /**
     * 建行支付回调
     * @param requestMap 回调参数
     */
    void notifyPayCbb(Map<String, String[]> requestMap);

    /**
     * 建行支付回退
     * @param requestMap 回调参数
     * @return 回退结果
     */
    String backActivity(Map<String, String[]> requestMap);

    /**
     * 杭州银行回调
     * @param requestMap 回调参数
     */
    void notifyPayHzBank(Map<String, String> requestMap);

}
