package cn.com.duiba.kjy.paycenter.api.dto.payment.response.cgb;

import lombok.Data;

import java.io.Serializable;

/**
 * @author nongfu
 * @Date 2024/10/15 10:48
 */
@Data
public class CgbQueryPayResponse implements Serializable {
    /**
     * 商户编号
     */
    private String merchantNum;
    /**
     * 请求方保留域
     */
    private String reqReserved;
    /**
     * 保留域
     */
    private String reserved;

    /**
     * 0000- 成功
     */
    private String errorCode;
    /**
     * 错误信息
     */
    private String errorMsg;
    /**
     * 订单状态
     */
    private String orderStatus;
    /**
     * 订单总金额
     */
    private String orderTotalAmt;
    /**
     * 订单实际支
     * 付金额
     */
    private String orderActualPayAmt;
    /**
     * 订单处理时间
     */
    private String orderHandleTime;
    /**
     * 积分数
     */
    private String integralNum;
    /**
     * 积分抵扣金
     * 额
     */
    private String integralAmt;
    /**
     * 退款金额
     */
    private String refundAmount;

    /**
     * 银行退款订
     * 单号
     */
    private String bankRefundOrderNo;
    /**
     * 退款单状态
     * 01-退款成功，00-待退
     * 款
     */
    private String refundStatus;

    /**
     * 第三方退款
     * 单号
     */
    private String refundOrderNo;

    private String couponsAmt;
    /**
     * 随机减活动
     * 优惠金额
     */
    private String randomActAmt;
    /**
     * 满减活动优
     * 惠金额
     */
    private String fullActAmt;
    /**
     * 消费金金额
     */
    private String finCoupAmt;


    public boolean success() {
        return "0000".equals(errorCode);
    }
}
