package cn.com.duiba.kjy.paycenter.api.enums;

/**
 * @author lizhi
 * @date 2020/3/3 10:32 AM
 */
public enum RedisKeyFactory {

    K001("支付回调通知 分布式锁"),
    K002("退款回调通知 分布式锁"),
    K003("企业付款到零钱 分布式锁"),
    K004("微信支付，预支付回话标识"),
    K005("订单状态同步，分布式锁"),
    ;

    private static final String SPACE = "KjyPayCenter";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
