package cn.com.duiba.kjy.paycenter.api.remoteservice.config;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.config.CiticPayMchConfDto;
import cn.com.duiba.kjy.paycenter.api.param.PageQuery;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2023/1/10 2:42 下午
 **/
@AdvancedFeignClient
public interface RemoteCiticPayMchConfService {
    /**
     * 分页查询
     * @param pageQuery 查询条件
     * @return 中信全付通商户配置集合
     */
    List<CiticPayMchConfDto> selectPage(PageQuery pageQuery);

    /**
     * 根据条件,查询记录的总记录数
     * @return 符合条件的记录数
     */
    Long selectCount();

    /**
     * 根据商户编号查询
     * @param merNo 商户编号
     * @return 中信全付通商户配置
     */
    CiticPayMchConfDto selectByMerNo(String merNo);

    /**
     * 根据主键查询
     * @param id 主键id
     * @return 中信全付通商户配置
     */
    CiticPayMchConfDto selectById(Long id);

    /**
     * 新增
     * @param dto 中信全付通商户配置
     * @return 执行结果
     */
    int insert(CiticPayMchConfDto dto);

    /**
     * 更新
     * @param dto 中信全付通商户配置
     * @return 执行结果
     */
    int update(CiticPayMchConfDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
