package cn.com.duiba.kjy.paycenter.api.annotation;

import cn.com.duiba.kjy.paycenter.api.validator.ChannelTypeEnumCheckConstraintValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 验证支付渠道是否在枚举定义中
 * @author lizhi
 * @date 2020/2/28 11:48 AM
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = { ChannelTypeEnumCheckConstraintValidator.class })
public @interface ChannelTypeEnumCheck {

    String message() default "非法channelType";

    Class<?>[] groups() default { };

    Class<? extends Payload>[] payload() default { };
}
