package cn.com.duiba.kjy.paycenter.api.dto.minsheng;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 民生银行支付订单额外信息
 * @author kjj mybatis generator 
 * @date 2024-06-06
 */
@Data
public class ChargeOrderMinshengDto implements Serializable {
     
    private static final long serialVersionUID = 17176617103493447L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 商户名称
     */
    private String merchInfo;

    /**
     * 商户唯一标志
     */
    private String merchantCode;

    /**
     * 支付成功回调的前端地址
     */
    private String callbackUrl;

    /**
     * 商品名称（多商品用英文分号隔开，如 AName;BName;CName)
     */
    private String productName;

    /**
     * 商品数量（多商品用英文分号隔开，如 ANum;BNum;CNum)
     */
    private String productNum;

    /**
     * 商品单价（单位：元）（多商品用英文分号隔开，如 Aprice;Bprice;Cprice)
     */
    private String productAmt;

    /**
     * 总价格（单位：元）
     */
    private String totalAmt;

    /**
     * 联名登录时传递的 token 值
     */
    private String token;

    /**
     * 最新支付回调或查询支付结果的回参
     */
    private String callbackParams;
}