package cn.com.duiba.kjy.paycenter.api.dto.payment.request.alipay;

import cn.com.duiba.kjy.paycenter.api.annotation.FieldMapKey;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 支付宝未支付订单 定时关闭 请求对象
 * @author 吴文哲
 * @date 2020-07-10 14:42
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class AliPayTradeCloseRequest extends AliPayCommonRequest{
    private static final long serialVersionUID = 5468835048165581342L;

    /**
     * 该交易在支付宝系统中的交易流水号。最短 16 位，最长 64 位。和out_trade_no不能同时为空，如果同时传了 out_trade_no和 trade_no，则以 trade_no为准
     */
    @FieldMapKey("trade_no")
    @NotBlank(message = "trade_no 不能为空")
    @Size(max = 64, message = "trade_no 过长")
    private String tradeNo;

    /**
     * 订单支付时传入的商户订单号,和支付宝交易号不能同时为空。 trade_no,out_trade_no如果同时存在优先取trade_no
     */
    @FieldMapKey("out_trade_no")
    @NotBlank(message = "out_trade_no 不能为空")
    @Size(max = 64, message = "out_trade_no 过长")
    private String outTradeNo;

    /**
     * 卖家端自定义的的操作员 ID
     */
    @FieldMapKey("operator_id")
    @NotBlank(message = "operator_id 不能为空")
    @Size(max = 28, message = "operator_id 过长")
    private String operatorId;

}
