package cn.com.duiba.kjy.paycenter.api.dto.payment.response.boc;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * BOC支付订单查询响应
 * @author yangyukang
 * @date 2025/1/27
 */
@Data
public class BocPayQueryResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 查询结果状态
     * true: 成功, false: 失败
     */
    private Boolean success;

    /**
     * 错误信息
     */
    private String errorMessage;

    /**
     * 头部信息
     */
    private Head header;

    /**
     * 内容信息
     */
    private Body body;

    /**
     * 头部信息
     */
    @Data
    public static class Head {

        /**
         * 报文标识号
         */
        private String msgId;

        /**
         * 处理状态
         * A-成功  B-失败  K-未明
         */
        private String hdlSts;

        /**
         * 业务体报文块存在标识
         * 0-有包体 1-无包体
         */
        private String bdFlg;

        /**
         * 报文处理返回码
         */
        private String rtnCd;
    }

    /**
     * 内容信息
     */
    @Data
    public static class Body {

        /**
         * 订单交易信息列表
         */
        private List<OrderTrans> orderTrans;
    }

    /**
     * 订单交易信息
     */
    @Data
    public static class OrderTrans {

        /**
         * 网关交易流水号
         */
        private String tranSeq;

        /**
         * 商户号
         */
        private String merchantNo;

        /**
         * 商户订单号
         */
        private String orderNo;

        /**
         * 商户流水号
         * 商户流水号，商户系统唯一，退款时mRefundSeq
         */
        private String custTranId;

        /**
         * 交易类型
         * 01:支付
         * 03:批量退货
         * 06:联机退货  单个退款用06查询
         */
        private String tranCode;

        /**
         * 交易时间
         * YYYYMMDDhhmiss 原交易的交易时间
         */
        private String tranTime;

        /**
         * 支付金额
         */
        private String tranAmount;

        /**
         * 交易状态
         * 交易状态0：待处理，1：成功，2：失败，3：未明
         */
        private String tranStatus;

        /**
         * 银联流水号
         */
        private String unionPaySeq;
    }
}
