package cn.com.duiba.kjy.paycenter.api.annotation;

import cn.com.duiba.kjy.paycenter.api.validator.MinExpireTimeConstraintValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author lizhi
 * @date 2020/2/28 11:57 AM
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = { MinExpireTimeConstraintValidator.class })
public @interface MinExpireTime {

    String message() default "过期支付时间最少1分钟";

    Class<?>[] groups() default { };

    Class<? extends Payload>[] payload() default { };
}
