package cn.com.duiba.kjy.paycenter.api.enums.citic;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2023/1/13 5:03 下午
 **/
@Getter
@AllArgsConstructor
public enum CiticCardTypeEnum {

    CITIC_DEBIT_CARD("01", "中信借记卡"),

    CITIC_CREDIT_CARD("02", "中信信用卡"),

    OTHER_DEBIT_CARD("03", "他行借记卡"),

    OHTER_CREDIT_CARD("04", "他行信用卡"),
    ;

    private final String type;

    private final String desc;

    private static Map<String, String> map = new HashMap<>();

    static {
        for (CiticCardTypeEnum value : values()) {
            map.put(value.getType(), value.getDesc());
        }
    }

    public static String getByCardType(String cardType) {
        return map.getOrDefault(cardType, StringUtils.EMPTY);
    }
}
