package cn.com.duiba.kjy.paycenter.api.dto.payment.response.minsheng;

import cn.com.duiba.kjy.paycenter.api.dto.payment.response.BaseChargeResponse;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;


/**
 * minsheng pay charge response
 *
 * @author wangguanhua
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MinshengPayChargeResponse extends BaseChargeResponse implements Serializable {

    private static final long serialVersionUID = 6191603318165153330L;

    /**
     * 商户唯一标志，联系 APP 提供，不能随便定义
     */
    private String isThirdLogin;

    /**
     * 加密的订单信息
     */
    private String params;

    @Data
    public static class MinshengPayChargeBizParams implements Serializable {

        private static final long serialVersionUID = -2427948894071468242L;

        /**
         * 支付成功回调的前端地址
         */
        @JSONField(name = "_CallBackUrl")
        private String callbackUrl;

        /**
         * 商户名称
         */
        private String merchInfo;

        /**
         * 订单号
         */
        private String orderNo;

        /**
         * 商品名称（多商品用英文分号隔开，如 AName;BName;CName)
         */
        private String productName;

        /**
         * 商品数量（多商品用英文分号隔开，如 ANum;BNum;CNum)
         */
        private String productNum;

        /**
         * 商品单价（单位：元）（多商品用英文分号隔开，如 Aprice;Bprice;Cprice)
         */
        private String productAmt;

        /**
         * 总价格（单位：元）
         */
        @JSONField(name = "TotalAmt")
        private String totalAmt;

        /**
         * 支付成功、异常后端通知地址
         */
        private String url;

        /**
         * 订单生成时间戳（单位：ms）
         */
        private String timeStamp;

        /**
         * 联名登录时传递的 token 值
         */
        private String token;
    }
}
