package cn.com.duiba.kjy.paycenter.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.boc.BocPayQueryRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.boc.BocRefundRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.boc.BocPayQueryResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.boc.RefundOrderBocDto;

/**
 * BOC银行专用远程服务接口
 * @author yangyukang
 * @date 2025/1/27
 */
@AdvancedFeignClient
public interface RemoteBocService {

    /**
     * 中行支付订单查询接口
     * @param queryRequest 查询请求参数
     * @return 查询结果
     * @throws BizException 业务异常
     */
    BocPayQueryResponse queryPayOrder(BocPayQueryRequest queryRequest) throws BizException;

    /**
     * 根据退款单号查询BOC退款订单
     * @param outRefundNo 退款单号
     * @return BOC退款订单DTO
     * @throws BizException 业务异常
     */
    RefundOrderBocDto selectByOutRefundNo(String outRefundNo) throws BizException;

    /**
     * BOC银行退款接口
     * @param bocRefundRequest BOC退款请求参数
     * @throws BizException 业务异常
     */
    void refundOrder(BocRefundRequest bocRefundRequest) throws BizException;
}
