package cn.com.duiba.kjy.paycenter.api.remoteservice.config;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.config.PayConfDto;
import cn.com.duiba.kjy.paycenter.api.param.PageQuery;

import java.util.List;

/**
 * 支付配置
 * @author kjj mybatis generator 
 * @date 2021-06-16
 */
@AdvancedFeignClient
public interface RemotePayConfService {
     
    /**
     * 分页查询
     * @param pageQuery 查询条件
     * @return 支付配置集合
     */
    List<PayConfDto> selectPage(PageQuery pageQuery);

    /**
     * 根据条件,查询记录的总记录数
     * @return 符合条件的记录数
     */
    Long selectCount();

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付配置
     */
    PayConfDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付配置
     * @return 执行结果
     */
    int saveOrUpdate(PayConfDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}