package cn.com.duiba.kjy.paycenter.api.validator;

import cn.com.duiba.kjy.paycenter.api.annotation.BizTypeEnumCheck;
import cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author lizhi
 * @date 2020/03/03
 */
public class BizTypeEnumCheckConstraintValidator implements ConstraintValidator<BizTypeEnumCheck, Integer> {

    private String message;

    @Override
    public void initialize(BizTypeEnumCheck constraintAnnotation) {
        this.message = constraintAnnotation.message();
    }

    @Override
    public boolean isValid(Integer value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (BizTypeEnum.isActive(value)) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        ConstraintValidatorContext.ConstraintViolationBuilder builder =
                context.buildConstraintViolationWithTemplate(message);
        builder.addConstraintViolation();
        return false;
    }
}
