package cn.com.duiba.kjy.shorturl.service.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 类型
 * @author lizhi
 * @date 2020/4/9 1:38 PM
 */
public enum ShortTypeEnum {

    MP_PARAM(1, "小程序参数"),
    URL_TRANS(2, "链接转换"),
    URL_MAPPING(3, "外链链接映射"),
    ;

    private Integer code;

    private String desc;

    ShortTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ShortTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ShortTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static ShortTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
