package cn.com.duiba.kjy.shorturl.service.api.enums.crypto;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/4/9 11:36 AM
 */
public enum IdConvertBase64Enum {

    /**
     * 注意，code只能是两位
     */
    DEF("j2", "默认类型"),
    TRANS("t3", "短链接服务"),
    ;

    private String code;

    private String desc;

    IdConvertBase64Enum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return CryptoTypeEnum.ID_BASE64.getCode() + code;
    }

    private static final Map<String, IdConvertBase64Enum> ENUM_MAP = new HashMap<>();

    static{
        for(IdConvertBase64Enum lengthEnum : values()){
            ENUM_MAP.put(lengthEnum.getCode(), lengthEnum);
        }
    }

    public static IdConvertBase64Enum getByCode(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
