package cn.com.duiba.kjy.shorturl.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.shorturl.service.api.dto.MpQrcodeDto;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2020/9/19 11:41 下午
 **/
@AdvancedFeignClient
public interface RemoteShortUrlMpQrcodeService {
    /**
     * 根据id获取参数
     *
     * @param qrcodeId 主键
     * @return 参数
     */
    String getSceneByQrcodeId(Long qrcodeId);

    /**
     * 根据id获取小程序码
     *
     * @param qrcodeId 主键
     * @return 小程序码
     */
    String getMpQrcodeUrlByQrcodeId(Long qrcodeId);

    /**
     * 根据业务key来获取小程序码
     *
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.shorturl.service.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务对应唯一key 由业务方提供 业务方可以根据该key来获取 长度不超过64
     * @return 小程序码
     */
    String getMpQrcodeUrlByBiz(Integer bizType, String bizKey);

    /**
     * 使用小程序码 更新状态和参数
     *
     * @param id    主键
     * @param scene 参数
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.shorturl.service.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务对应唯一key 由业务方提供 业务方可以根据该key来获取 长度不超过64
     * @return 执行结果
     */
    int useMpQrcode(Long id, String scene, Integer bizType, String bizKey);

    /**
     * 批量使用小程序码，更新状态和参数
     * @param list
     * @return 执行结果
     */
    int batchUseMpQrcode(List<MpQrcodeDto> list);

    /**
     * 批量初始化主键id
     *
     * @param count 批量初始化数量
     * @return 主键id集合
     */
    @Deprecated
    List<Long> batchInitQrcodeId(int count);

    /**
     * 批量初始化主键id
     * @param count 批量初始化数量
     * @param dataType 数据类型
     * @see cn.com.duiba.kjy.shorturl.service.api.enums.MpQrCodeDataTypeEnum
     * @return 主键id集合
     */
    List<Long> batchInitId(int count,Integer dataType);

    /**
     * 批量更新
     *
     * @param list 小程序码
     * @return 执行结果
     */
    int batchUpdateMpQrcodeUrlAndStatus(List<MpQrcodeDto> list);

    /**
     * 查询可用已使用的码
     *
     * @param bizType {@link cn.com.duiba.kjy.shorturl.service.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务key
     * @return 小程序码
     */
    String selectMpQrcodeUrlByBiz(Integer bizType, String bizKey);
}
