package cn.com.duiba.kjy.teamcenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.teamcenter.api.dto.SellerTeamMemberInfoDto;
import cn.com.duiba.kjy.teamcenter.api.dto.SellerTeamRelationDto;
import cn.com.duiba.kjy.teamcenter.api.enums.seller.SellerTeamStickStateEnum;
import cn.com.duiba.kjy.teamcenter.api.params.Page;

import java.util.List;

/**
 * 销售团队remote
 * @author zhanghuifeng
 * date 2020/3/24-10:44 上午
 */
@AdvancedFeignClient
public interface RemoteSellerTeamService {

    /**
     * 绑定上下级
     * @param parentSid 邀请人销售ID
     * @param sellerId 销售ID
     * @return 结果
     */
    Boolean bound(Long parentSid, Long sellerId);

    /**
     * 根据下级ID查询条数
     * @param sellerId 下级销售ID
     * @return 条数
     */
    int countBySid(Long sellerId);

    /**
     * 获取所有上级代理人id集合
     * @param sellerId 代理人ID
     * @return 上级代理人ID
     */
    List<Long> findParentSids(Long sellerId);

    /**
     * 获取当前代理人上级ID
     * @param sellerId 代理人ID
     * @return 上级ID
     */
    Long findParentId(Long sellerId);

    /**
     * 分页查询团队人员信息（直属团队）
     * @param superiorId
     * @param pageIndex
     * @param pageSize
     * @return
     */
    Page<SellerTeamMemberInfoDto> pageMember(Long superiorId, Integer pageIndex, Integer pageSize);

    /**
     * 根据上级和下级ID批量查询
     * @param sellerIds
     * @param superiorId
     * @return
     */
    List<SellerTeamRelationDto> listBySellerIdsAndSuperiorId(List<Long> sellerIds, Long superiorId);

    /**
     * 移除团队成员
     * @param superiorId 上级销售ID
     * @param removeSids 需要移除的成员
     * @return
     */
    Boolean removeMember(Long superiorId, List<Long> removeSids);

    /**
     * 根据上级查询直属下级人数
     * @param superiorId
     * @return
     */
    int countBySuperiorId(Long superiorId);

    /**
     * 更新置顶状态
     * @param superiorId
     * @param sellerId
     * @param stickState {@link SellerTeamStickStateEnum}
     * @return
     */
    Boolean updateStickState(Long superiorId, Long sellerId, Integer stickState);

    /**
     * 通过上级查询所有直属下级销售ID集合
     * @param superiorId 上级销售ID
     * @return 集合
     */
    List<Long> findSellerIdsBySuperiorId(Long superiorId);
}
