/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.voice.service.api.enums;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum LiveStatusApiEnum {
    LIVE_NOTICE(1, "\u672a\u5f00\u59cb"),
    LIVE_PROCESSING(2, "\u76f4\u64ad\u4e2d"),
    LIVE_INTERRUPT(3, "\u65ad\u7f51"),
    DATA_STATISTIC_ING(4, "\u6570\u636e\u7edf\u8ba1\u4e2d"),
    DATA_STATISTIC_END(5, "\u6570\u636e\u7edf\u8ba1\u5b8c\u6210"),
    DATA_STATISTIC_FAILED(6, "\u6570\u636e\u7edf\u8ba1\u5931\u8d25,\u5b9a\u65f6\u4efb\u52a1\u81ea\u52a8\u91cd\u8bd5");

    public static final List<Integer> END_STATUS;
    public static final List<Integer> NOT_OVER_STATUS;
    public static final List<Integer> LIVING_STATUS;
    public static final List<Integer> NOT_STATISTICS_END;
    private Integer code;
    private String desc;
    private static final Map<Integer, LiveStatusApiEnum> ENUM_MAP;

    private LiveStatusApiEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LiveStatusApiEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public static boolean isEnd(Integer code) {
        LiveStatusApiEnum statusEnum = LiveStatusApiEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum.equals((Object)DATA_STATISTIC_ING) || statusEnum.equals((Object)DATA_STATISTIC_END) || statusEnum.equals((Object)DATA_STATISTIC_FAILED);
    }

    public static boolean isStarted(Integer code) {
        return !LIVE_NOTICE.getCode().equals(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        END_STATUS = Collections.unmodifiableList(Lists.newArrayList((Object[])new Integer[]{4, 5, 6}));
        NOT_OVER_STATUS = Collections.unmodifiableList(Lists.newArrayList((Object[])new Integer[]{1, 2, 3}));
        LIVING_STATUS = Collections.unmodifiableList(Lists.newArrayList((Object[])new Integer[]{2, 3}));
        NOT_STATISTICS_END = Collections.unmodifiableList(Lists.newArrayList((Object[])new Integer[]{4, 6}));
        ENUM_MAP = new HashMap<Integer, LiveStatusApiEnum>();
        for (LiveStatusApiEnum statusEnum : LiveStatusApiEnum.values()) {
            ENUM_MAP.put(statusEnum.getCode(), statusEnum);
        }
    }
}

