package cn.com.duiba.kjy.api.api.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by dugq on 2020-03-11.
 * 微信素材类型
 */
public enum WechatMaterialTypeEnum {
    IMG("image","图片"),
    VIDEO("video","视频"),
    VOICE("voice","语音"),
    THUMB("thumb","缩略图")

    ;
    private String code;
    private String desc;

    WechatMaterialTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static WechatMaterialTypeEnum getByCode(String code) {
        for (WechatMaterialTypeEnum e :values())
            if (StringUtils.equals(code, e.getCode())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息类型");
    }
}
