package cn.com.duiba.kjy.api.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 小程序码业务类型枚举
 *
 * @author xuzhigang
 * @date 2020/9/22 12:28 下午
 **/
@Getter
@AllArgsConstructor
public enum MpQrcodeBizTypeEnum {
    LIVE_VISITOR_SHARE(1, OATypeEnum.LIVE_USER_MP.getType(), "pages/index/index", "kjy/live/mpQrCode", "直播访客分享"),

    LIVE_AGENT_SHARE(2,  OATypeEnum.LIVE_USER_MP.getType(), "pages/index/index", "kjy/live/mpQrCode", "直播代理人分享"),

    LIVE_AGENT_JOIN_TEAM(3,  OATypeEnum.LIVE_USER_MP.getType(), "pages/index/index", "kjy/live/mpQrCode", "直播代理人加入团队"),

    LIVE_AGENT_AUTO_REPAY(4, OATypeEnum.LIVE_USER_MP.getType(), "pages/index/index", "kjy/live/mpQrCode", "直播代理人自动回复"),

    LIVE_ADMIN_SHARE(5, OATypeEnum.LIVE_USER_MP.getType(), "pages/index/index", "kjy/live/mpQrCode", "直播管理员分享"),

    LIVE_SPREAD_LINK(6, OATypeEnum.LIVE_USER_MP.getType(), "pages/index/index", "kjy/live/mpQrCode", "直播推广链接"),

    KJJ_SELLER_CARD_SHARE(11, OATypeEnum.MP.getType(), "pages/scene/main", "kjy/card/mpQrCode", "客集集名片二维码分享"),

    ;
    /**
     * 业务类型
     */
    private Integer type;

    /**
     * 主体类型
     */
    private Integer oaType;

    /**
     * 小程序码跳转页
     */
    private String page;

    /**
     * 小程序码上传至oss地址前缀
     */
    private String ossPrefix;

    /**
     * 描述
     */
    private String desc;

    private static Map<Integer, MpQrcodeBizTypeEnum> map = new HashMap<>();

    static {
        for (MpQrcodeBizTypeEnum value : values()) {
            map.put(value.getType(), value);
        }
    }

    public static MpQrcodeBizTypeEnum getEnumByType(Integer type) {
        return map.get(type);
    }

}
