package cn.com.duiba.kjy.api.api.enums;

import lombok.Getter;

/**
 * 推送用户类型枚举
 * @author 吴文哲
 * @date 2020-07-27 13:57
 **/
@Getter
public enum PushUserTypeEnum {

    PAID_INSURANCE_VERSION_USER(1,"付费保险版用户",0),
    PAID_COMMON_VERSION_USER(2,"付费通用版版用户",0),
    PAID_EDU_VERSION_USER(3,"付费教培版用户",0),
    UN_PAID_INSURANCE_VERSION_USER(4,"未付费保险版用户",180),
    UN_PAID_COMMON_VERSION_USER(5,"未付费通用版用户",180),
    UN_PAID_EDU_VERSION_USER(6,"未付费教培版用户",180),
    LIVE_INSURANCE_VERSION_USER(7,"直播保险版适用账号",300),
    LIVE_COMMON_VERSION_USER(8,"直播通用版适用账号",300),
    ;

    /**
     * 用户类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    /**
     * 延时推送时间 单位秒
     */
    private Integer delaySeconds;


    PushUserTypeEnum(Integer type, String desc, Integer delaySeconds){
        this.type = type;
        this.desc = desc;
        this.delaySeconds = delaySeconds;
    }
}
