package cn.com.duiba.kjy.api.api.param.secure;

import cn.com.duiba.kjy.api.api.param.WxBaseParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.util.List;


/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/11/18 14:07
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BatchMpUserRiskRankParam extends WxBaseParam {

    private static final long serialVersionUID = 3800890145750090898L;

    /**
     * 小程序appId
     */
    @NotBlank(message = "小程序appId不能为空")
    private String appId;

    /**
     * 用户信息集合
     */
    @NotEmpty(message = "用户信息集合不能为空")
    @Size(max = 1000, message = "openid列表个数不能超过1000个")
    private List<RiskRankUserParam> paramList;
}
