package cn.com.duiba.kjy.api.api.param.secure;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/11/18 14:09
 */
@Data
public class RiskRankUserParam implements Serializable {

    /**
     * 用户的openid
     */
    @NotBlank(message = "用户openId不能为空")
    private String openId;

    /**
     * 场景值，0:注册，1:营销作弊
     * @see cn.com.duiba.kjy.api.api.enums.MpSecureSceneEnum
     */
    @NotNull(message = "安全场景值不能为null")
    private Integer scene;

    /**
     * 用户访问源ip
     */
    @NotBlank(message = "用户访问源ip不能为空")
    private String clientIp;

    /**
     * 业务类型，仅在日志中记录上层业务来源信息
     */
    private String bizKey;
}
