package cn.com.duiba.kjy.api.api.param.secure;

import cn.com.duiba.kjy.api.api.param.WxBaseParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/11/16 19:56
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxMpUserRiskRankParam extends WxBaseParam {

    private static final long serialVersionUID = -8492842084042245139L;

    /**
     * 小程序appId
     */
    @NotBlank(message = "小程序appId不能为空")
    private String appId;

    /**
     * 用户信息
     */
    @NotNull(message = "用户信息不能为null")
    private RiskRankUserParam userParam;
}
