package cn.com.duiba.kjy.api.api.remoteservice.message;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wxmessage.wrapper.BatchWxMessageWrapperDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.wrapper.SingleWxMessageWrapperDto;

import java.util.concurrent.TimeUnit;

/**
 * Created by dugq on 2020-02-11.
 * 异步发送公众号消息
 */
@AdvancedFeignClient
public interface RemoteAsyncOaMessageSenderService {
    /**
     * 异步发送客服消息
     * 不入mq队列 优先发送
     * @param singleWxMessageWrapperDto 客服消息包装体
     */
    void sendCustomerMessage(SingleWxMessageWrapperDto singleWxMessageWrapperDto);

    /**
     * 异步发送模版消息
     * 不入mq队列 优先发送
     * @param singleWxMessageWrapperDto 模版消息包装体
     */
    void sendTemplateMessage(SingleWxMessageWrapperDto singleWxMessageWrapperDto);


    /**
     * 异步发送消息
     * 不入mq队列 优先发送
     * @param singleWxMessageWrapperDto 消息包装体
     */
    void sendSubscribeMessage(SingleWxMessageWrapperDto singleWxMessageWrapperDto);

    /**
     * 异步发送单条消息
     * 进mq队列，可延时推送
     * @param singleWxMessageWrapperDto 消息包装体
     * @param times 时间
     * @param timeUnit 时间单位
     */
    void sendSingleMessage(SingleWxMessageWrapperDto singleWxMessageWrapperDto, Long times, TimeUnit timeUnit);

    /**
     * 异步发送批量消息
     * 进mq队列，可延时推送
     * @param batchWxMessageWrapperDto 订阅消息包装体
     * @param times 时间
     * @param timeUnit 时间单位
     */
    void sendBatchMessage(BatchWxMessageWrapperDto batchWxMessageWrapperDto, Long times, TimeUnit timeUnit);
}
