package cn.com.duiba.kjy.api.api.remoteservice.qrcode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.qrcode.MpQrcodeBatchBindResultDto;
import cn.com.duiba.kjy.api.api.dto.qrcode.MpQrcodeSimpleDto;
import cn.com.duiba.kjy.api.api.param.MpQrCodeBatchBindParam;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2020/9/19 11:41 下午
 **/
@AdvancedFeignClient
public interface RemoteMpQrcodeService {
    /**
     * 根据id获取参数
     *
     * @param qrcodeId 主键
     * @return 参数
     */
    String getSceneByQrcodeId(Long qrcodeId);

    /**
     * 根据id获取小程序码
     *
     * @param qrcodeId 主键
     * @return 小程序码
     */
    String getMpQrcodeUrlByQrcodeId(Long qrcodeId);

    /**
     * 根据业务key来获取小程序码
     *
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务对应唯一key 由业务方提供 业务方可以根据该key来获取 长度不超过64
     * @return 小程序码
     */
    String getMpQrcodeUrlByBiz(Integer bizType, String bizKey);

    /**
     * 根据oaType批量创建小程序码 创建成功后将码加载进redis list中，使用码时直接操作redis即可
     * redisKey {@link cn.com.duiba.kjy.bean.MpQrcodeRedisKeyFactory}
     * value {@link cn.com.duiba.kjy.api.api.dto.qrcode.MpQrcodeSimpleDto}
     *
     * @param oaType 小程序主体类型 {@link cn.com.duiba.kjy.api.api.enums.OATypeEnum}
     */
    void batchCreateMpQrcodeByOaType(Integer oaType);

    /**
     * 绑定小程序微信二维码 返回小程序码地址
     * @param oaType 小程序主体类型 {@link cn.com.duiba.kjy.api.api.enums.OATypeEnum}
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务key
     * @param scene 场景值
     * @return 小程序二维码url地址
     */
    String bindMpQrCode(Integer oaType, Integer bizType, String bizKey, String scene);

    /**
     * 绑定小程序微信二维码 返回小程序码地址和id
     *
     * @param oaType 小程序主体类型 {@link cn.com.duiba.kjy.api.api.enums.OATypeEnum}
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务key
     * @param scene 场景值
     * @return 小程序二维码
     */
    MpQrcodeSimpleDto bindMpQrCodeGetDto(Integer oaType, Integer bizType, String bizKey, String scene);

    /**
     * 批量绑定小程序二维码，建议一次处理不超过30条，
     * 没有重试，由业务方自己实现降级方案
     * @param param 绑定参数
     * @return 绑定结果
     */
    List<MpQrcodeBatchBindResultDto> batchBind(MpQrCodeBatchBindParam param);
}
