package cn.com.duiba.kjy.api.api.dto.qrcode;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 公众号二维码参数表。
 * @author kjj mybatis generator
 * 2020-11-25
 */
@Data
public class OaQrcodeParamDto implements Serializable {
    private static final long serialVersionUID = 16062848059048868L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *公众号ID
     * not null default = null
     */
    private Long oaId;

    /**
     *
     *参数详情
     * max length = 256
     * not null default = null
     */
    private String param;


    /**
     * 二维码状态 1：有用 0：失效
     */
    private Integer codeStatus;

    /**
     * 业务类型
     * @see cn.com.duiba.kjy.api.api.enums.OaQrCodeTypeEnum
     */
    private Integer bizType;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}
