package cn.com.duiba.kjy.api.api.dto.secure;

import lombok.Data;

import java.io.Serializable;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/12/3 11:05
 */
@Data
public class MpUserRiskRankResultDto implements Serializable {

    /**
     * 用户的openid
     */
    private String openId;

    /**
     * 场景值，0:注册，1:营销作弊
     * @see cn.com.duiba.kjy.api.api.enums.MpSecureSceneEnum
     */
    private Integer scene;

    /**
     * 唯一标识值，如果需要接受结果可设置该值，结果通知时可根据此值处理对应的业务
     * 如可以传用户id/代理人id/其他唯一业务场景唯一标识作为值，收到结果根据此值具体处理
     */
    private String unionKey;

    /**
     * 风险等级，级别越高表示风险越高
     * @see cn.com.duiba.kjy.api.api.enums.MpUserRiskRankEnum
     */
    private Integer riskRank;
}
