package cn.com.duiba.kjy.api.api.remoteservice.qrcode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.qrcode.MpQrCodeResultDto;
import cn.com.duiba.kjy.api.api.param.qrcode.MpQrcodeParam;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

/**
 * 生成带参数的小程序二维码服务<br/>
 * 因为微信返回的是二维码的二进制字节流，所以额外加了一步上传到oss的操作。返回的是OSS的文件地址<br/>
 * 暂为开放返回二进制字节流的接口。<br/>
 * https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/qr-code/wxacode.getUnlimited.html#method-http
 * @author dugq
 * @date 2020/11/16 4:44 下午
 */
@AdvancedFeignClient
public interface RemoteWechatMpQrcodeService {

    /**
     * 生成带参数小程序二维码
     * @param oaId 小程序的oaID
     * @param objectName oss存储的路径名。
     * @param mpQrcodeParam 二维码的配置参数
     * @return 二维码地址。请先根据 errCode 状态判断，再获取url
     */
    @NotNull
    MpQrCodeResultDto getWxacodeUnlimitDefult(Long oaId, String objectName, MpQrcodeParam mpQrcodeParam);

    /**
     * 采用默认配置，生成带参数小程序二维码。避免构建二维码配置对象
     * @param scene 场景值ID。详见：{@link MpQrcodeParam#getScene}
     * @param page  扫码打开的小程序页面地址。详见：{@link MpQrcodeParam#getPage()}
     * @param objectName oss存储的路径名。
     * @param oaId 小程序的oaID
     * @return 二维码的oss完整地址。失败，返回NULL
     */
    @Nullable
    String getDefaultWxacodeUnlimitDefult(String scene, String page, String objectName, Long oaId);
}
