package cn.com.duiba.kjy.api.api.dto.menu;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * 个性化菜单规则
 * @author lizhi
 * @date 2020/9/29 11:59 AM
 */
@Data
public class MatchRuleDto implements Serializable {

    private static final long serialVersionUID = -418575246112900936L;

    /**
     * 用户标签的id，可通过用户标签管理接口获取
     */
    @JSONField(name = "group_id")
    private String tagId;

    /**
     * 性别：男（1）女（2），不填则不做匹配
     */
    private String sex;

    /**
     * 客户端版本，当前只具体到系统型号：IOS(1), Android(2),Others(3)，不填则不做匹配
     */
    @JSONField(name = "client_platform_type")
    private String clientPlatformType;

    /**
     * 国家信息，是用户在微信中设置的地区，具体请参考地区信息表
     */
    private String country;

    /**
     * 省份信息，是用户在微信中设置的地区，具体请参考地区信息表
     */
    private String province;

    /**
     * 城市信息，是用户在微信中设置的地区，具体请参考地区信息表
     */
    private String city;

    /**
     * 语言信息，是用户在微信中设置的语言，具体请参考语言表
     */
    private String language;
}
