package cn.com.duiba.kjy.api.api.dto.qrcode;

import cn.com.duiba.kjy.api.api.dto.WechatBaseResponseDto;
import lombok.Data;
import lombok.ToString;

/**
 * @author dugq
 * @date 2020/11/16 2:20 下午
 */
@Data
@ToString(callSuper = true)
public class OaQrcodeResultDto extends WechatBaseResponseDto {

    private static final long serialVersionUID = -7255279798522447343L;

    /**
     * 获取的二维码ticket，凭借此ticket可以在有效时间内换取二维码。
     * 在用户扫码回调时会传递回来
     */
    private String ticket;

    /**
     * 该二维码有效时间，以秒为单位。 最大不超过2592000（即30天）
     * 临时类型二维码有效
     */
    private Long expireSeconds;

    /**
     * 二维码地址
     */
    private String url;
}
