package cn.com.duiba.kjy.api.api.enums;

/**
 * 小程序码相关redis key
 *
 * @author xuzhigang
 * @date 2020/9/21 11:45 上午
 **/
public enum MpQrcodeRedisKeyFactory {
    @Deprecated
    KC001("已生成未使用小程序码队列"),
    KC002("刷新未使用小程序码队列，分布式锁"),
    KC003("降级创建小程序码，分布式锁"),
    KC004("已生成未使用小程序码队列 oaId"),
    ;

    MpQrcodeRedisKeyFactory(String desc) {
        this.desc = desc;
    }

    private String desc;

    private static final String SPACE = "mpQrcode";
    private static final String SEPARATOR = "_";

    /**
     * 需要追加参数作为key时使用，参数会以SEPARATOR隔开
     * @param args
     * @return
     */
    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg : args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    /**
     * 直接返回拼装后完整的key
     * @return
     */
    @Override
    public String toString() {
        return SPACE +SEPARATOR+ this.name();
    }

    public String getDesc() {
        return desc;
    }
}
