package cn.com.duiba.kjy.api.api.remoteservice.qrcode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.qrcode.OaQrcodeParamDto;
import cn.com.duiba.kjy.api.api.param.qrcode.AddOaQrcodeParam;

/**
 * @author dugq
 * @date 2020/11/25 7:19 下午
 */
@AdvancedFeignClient
public interface RemoteOaQrcodeParamService {

    /**
     * 通过ID查询公众号二维码的参数详情
     * @param id 参数ID
     * @return 参数详情
     */
    OaQrcodeParamDto selectOne(Long id);

    /**
     * 跟新二维码的状态。
     * @param id 二维码的ID
     * @param status 状态 0：无效，1：有效
     * @return
     */
    int updateStatus(Long id, Integer status);

    /**
     * 新增一张公众号二维码
     * @param param 二维码信息
     * @return ID
     */
    Long insert(AddOaQrcodeParam param);
}
