package cn.com.duiba.kjy.api.api.utils;

import cn.com.duiba.kjy.api.api.dto.menu.ButtonDto;
import cn.com.duiba.kjy.api.api.dto.menu.MatchRuleDto;
import cn.com.duiba.kjy.api.api.dto.menu.SubButtonDto;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * @author lizhi
 * @date 2020/10/14 4:54 PM
 */
public class WxMenuEqualsUtils implements Serializable {

    private static final long serialVersionUID = -1973210433453047505L;

    /**
     * 比较两组一级菜单是否完全一致（null和空字符串认为相同，null和空集合也认为相同）
     * @param button1 第一组一级菜单
     * @param button2 第二组一级菜单
     * @return true-完全一致，false-有不一致的
     */
    public static boolean isSameButton(List<ButtonDto> button1, List<ButtonDto> button2) {
        if (!isSameListSize(button1, button2)) {
            return false;
        }
        if (CollectionUtils.isEmpty(button1)) {
            //两个都是空集合
            return true;
        }
        for (int i = 0; i < button1.size(); i++) {
            boolean sameButton = isSameButton(button1.get(i), button2.get(i));
            if (!sameButton) {
                //有任何一个菜单不同，都算菜单不同
                return false;
            }
        }
        return true;
    }

    /**
     * 判断是否是相同的规则（null和空字符串认为相同，null和空集合也认为相同）
     * @param ruleDto1 规则1
     * @param ruleDto2 规则2
     * @return true-规则相同，false-规则不同
     */
    public static boolean isSameMatchRule(MatchRuleDto ruleDto1, MatchRuleDto ruleDto2) {
        if (ruleDto1 == null && ruleDto2 == null) {
            return true;
        }
        if (ruleDto1 == null || ruleDto2 == null) {
            return false;
        }
        if (!isSameStr(ruleDto1.getTagId(), ruleDto2.getTagId())) {
            return false;
        }
        if (!isSameStr(ruleDto1.getSex(), ruleDto2.getSex())) {
            return false;
        }
        if (!isSameStr(ruleDto1.getClientPlatformType(), ruleDto2.getClientPlatformType())) {
            return false;
        }
        if (!isSameStr(ruleDto1.getCountry(), ruleDto2.getCountry())) {
            return false;
        }
        if (!isSameStr(ruleDto1.getProvince(), ruleDto2.getProvince())) {
            return false;
        }
        if (!isSameStr(ruleDto1.getCity(), ruleDto2.getCity())) {
            return false;
        }
        return isSameStr(ruleDto1.getLanguage(), ruleDto2.getLanguage());
    }

    private static boolean isSameButton(ButtonDto button1, ButtonDto button2) {
        if (button1 == null && button2 == null) {
            return true;
        }
        if (button1 == null || button2 == null) {
            return false;
        }
        if (!isSameStr(button1.getName(), button2.getName())) {
            return false;
        }
        if (!isSameStr(button1.getType(), button2.getType())) {
            return false;
        }
        if (!isSameStr(button1.getUrl(), button2.getUrl())) {
            return false;
        }
        if (!isSameStr(button1.getAppId(), button2.getAppId())) {
            return false;
        }
        if (!isSameStr(button1.getPagePath(), button2.getPagePath())) {
            return false;
        }
        return isSameSubButtonList(button1.getSubButton(), button2.getSubButton());
    }

    private static boolean isSameSubButtonList(List<SubButtonDto> subButton1, List<SubButtonDto> subButton2) {
        if (!isSameListSize(subButton1, subButton2)) {
            return false;
        }
        if (CollectionUtils.isEmpty(subButton1)) {
            //两个都是空集合
            return true;
        }
        for (int i = 0; i < subButton1.size(); i++) {
            boolean sameSubButton = isSameSubButton(subButton1.get(i), subButton2.get(i));
            if (!sameSubButton) {
                //有任何一个子菜单不同，都算子菜单不同
                return false;
            }
        }
        return true;
    }

    private static boolean isSameSubButton(SubButtonDto subButton1, SubButtonDto subButton2) {
        if (subButton1 == null && subButton2 == null) {
            return true;
        }
        if (subButton1 == null || subButton2 == null) {
            return false;
        }
        if (!isSameStr(subButton1.getName(), subButton2.getName())) {
            return false;
        }
        if (!isSameStr(subButton1.getType(), subButton2.getType())) {
            return false;
        }
        if (!isSameStr(subButton1.getUrl(), subButton2.getUrl())) {
            return false;
        }
        if (!isSameStr(subButton1.getAppId(), subButton2.getAppId())) {
            return false;
        }
        return isSameStr(subButton1.getPagePath(), subButton2.getPagePath());
    }

    /**
     * 判断字符串是否相同（null和空字符串认为是相同的）
     * @param str1 字符串1
     * @param str2 字符串2
     * @return true-相同，false-不相同
     */
    private static boolean isSameStr(String str1, String str2) {
        if (StringUtils.isBlank(str1) && StringUtils.isBlank(str2)) {
            return true;
        }
        if (StringUtils.isBlank(str1) || StringUtils.isBlank(str2)) {
            return false;
        }
        return Objects.equals(str1, str2);
    }

    /**
     * 判断集合元素个数是否相同（null和空集合都认为0个元素）
     * @param list1 集合1
     * @param list2 集合2
     * @param <T> 元素类型
     * @return true-相同，false-不相同
     */
    private static <T> boolean isSameListSize(List<T> list1, List<T> list2) {
        if (CollectionUtils.isEmpty(list1) && CollectionUtils.isEmpty(list2)) {
            return true;
        }
        if (CollectionUtils.isEmpty(list1) || CollectionUtils.isEmpty(list2)) {
            return false;
        }
        return list1.size() == list2.size();
    }
}
