package cn.com.duiba.kjy.api.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.response.BaseResponse;
import cn.com.duiba.kjy.api.api.dto.response.tag.CreateTagResponse;
import cn.com.duiba.kjy.api.api.dto.response.tag.GetTagListResponse;
import cn.com.duiba.kjy.api.api.param.WxBaseParam;
import cn.com.duiba.kjy.api.api.param.tag.CreateTagParam;
import cn.com.duiba.kjy.api.api.param.tag.DeleteTagParam;
import cn.com.duiba.kjy.api.api.param.tag.UpdateTagParam;

/**
 * 微信标签管理
 * @author lizhi
 * @date 2020/9/29 2:17 PM
 */
@AdvancedFeignClient
public interface RemoteWxTagService {

    /**
     * 创建标签
     * @param param 创建标签
     * @return 标签ID
     */
    CreateTagResponse createTag(CreateTagParam param);

    /**
     * 编辑标签
     * @param param 标签参数
     * @return 是否成功
     */
    BaseResponse updateTag(UpdateTagParam param);

    /**
     * 获取公众号标签列表
     * @param param 参数
     * @return 公众号标签列表
     */
    GetTagListResponse getTagList(WxBaseParam param);

    /**
     * 删除标签
     * @param param 删除标签参数
     * @return 是否成功
     */
    BaseResponse deleteTag(DeleteTagParam param);
}
