package cn.com.duiba.kjy.api.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.response.BaseResponse;
import cn.com.duiba.kjy.api.api.dto.response.tag.GetTagUserListResponse;
import cn.com.duiba.kjy.api.api.dto.response.tag.UserTagIdListResponse;
import cn.com.duiba.kjy.api.api.param.tag.BatchTaggingParam;
import cn.com.duiba.kjy.api.api.param.tag.BatchUnTaggingParam;
import cn.com.duiba.kjy.api.api.param.tag.TagUserListParam;
import cn.com.duiba.kjy.api.api.param.tag.UserTagIdListParam;
import cn.com.duiba.kjy.api.api.param.tag.UserTaggingParam;

import java.util.List;

/**
 * 微信用户标签管理
 * @author lizhi
 * @date 2020/9/29 2:17 PM
 */
@AdvancedFeignClient
public interface RemoteWxUserTagService {

    /**
     * 获取标签下粉丝列表
     * @param param 获取标签下粉丝列表参数
     * @return 是否成功
     */
    GetTagUserListResponse getTagUserList(TagUserListParam param);

    /**
     * 批量为用户打标签
     * @param param 参数
     * @return 标签ID
     */
    BaseResponse batchTagging(BatchTaggingParam param);

    /**
     * 批量为用户取消标签
     * @param param 参数
     * @return 是否成功
     */
    BaseResponse batchUnTagging(BatchUnTaggingParam param);

    /**
     * 获取用户身上的标签列表
     * @param param 参数
     * @return 用户身上的标签列表
     */
    UserTagIdListResponse getUserTagIdList(UserTagIdListParam param);

    /**
     * 异步给用户打标签（如果原来已有则取消原来的再打标签）
     * @param param 参数
     */
    void asyncTagging(UserTaggingParam param);

    /**
     * 异步 批量给用户打标签（如果原来已有则取消原来的再打标签）
     * @param paramList 参数集合
     */
    void asyncBatchTagging(List<UserTaggingParam> paramList);

    /**
     * 异步重试（用于定时任务）
     * 将50秒-5分钟后还没有执行的任务，发起重试，并打印error日志
     */
    void asyncRetry();
}
