package cn.com.duiba.kjy.api.api.dto.wxmessage;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;
import java.util.Map;

/**
 * Created by dugq on 2020-02-07.
 *  发送目标客户对象
 */
@Data
public class MessageUserDto implements Serializable {
    private static final long serialVersionUID = -5993475953485160587L;

    /**
     * 发送目标客户的open ID
     */
    @NotBlank(message = "openId 不能为空")
    private String openId;
    /**
     * 发送目标客户的sellerID
     * 需要日志打印，或者 填充模版的必填
     */
    private Long sellerId;

    /**
     *  发送目标客户的名称（销售名称）
     */
    private String sellerName;

    /**
     * 公众号ID
     */
    private Long oaId;

    /**
     * 微信昵称
     */
    private String nickName;

    /**
     * 每个用户不同的额外参数
     */
    private Map<String,Serializable> customMap;

}
