package cn.com.duiba.kjy.api.api.param.tag;

import cn.com.duiba.kjy.api.api.param.WxBaseParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 批量为用户打标签
 * @author lizhi
 * @date 2020/9/29 2:08 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BatchTaggingParam extends WxBaseParam {

    private static final long serialVersionUID = -5396134003497281723L;

    /**
     * 微信标签名称
     */
    @NotBlank(message = "标签id不能为空")
    private String wxTagId;

    /**
     * 用户openid列表
     */
    @NotNull(message = "openid列表不能为空")
    @Size(max = 50, message = "openid列表个数不能超过50个")
    private List<String> openIdList;
}
