package cn.com.duiba.kjy.api.api.param;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

/**
 * 创建海报参数
 * 将海报oss地址缓存至指定redisKey
 *
 * @author xuzhigang
 * @date 2021/6/3 8:21 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class CreatePosterParam extends BasePosterParam implements Serializable {
    private static final long serialVersionUID = 4793749161462500748L;

    /**
     * 缓存key
     */
    private String cacheKey;

    /**
     * 缓存时间
     * @deprecated 兼容 后续可删除
     */
    @Deprecated
    private Integer timeout;

    /**
     * 缓存时间单位
     * @deprecated 兼容 后续可删除
     */
    @Deprecated
    private TimeUnit timeUnit;
}
