package cn.com.duiba.kjy.api.api.param;

import cn.com.duiba.kjy.api.api.dto.wxmessage.innerlog.WxSendEmbedDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

/**
 * 画海报并上传微信获取mediaId推送至指定用户公众号
 *
 * @author liuchao1
 * @version 1.0
 * @date 2020/10/23 13:33
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PosterParam extends BasePosterParam implements Serializable {

    private static final long serialVersionUID = -4140525933447656742L;

    /**
     * 需要上传的oaId
     */
    @NotNull
    private Long oaId;

    /**
     * 推送公众号目标类型，目前只支持小程序和公众号
     * @see cn.com.duiba.kjy.api.api.enums.OaTargetEnum
     */
    private Integer oaTargetType;

    /**
     * 需要推送的用户openId
     */
    private String openId;

    /**
     * 推送埋点
     */
    private WxSendEmbedDto wxSendEmbedDto;

    /**
     * 是否缓存
     */
    private boolean cache;

    /**
     * 缓存key，需要缓存时该值必传
     */
    private String cacheKey;

    /**
     * 缓存时间，需要缓存时该值必传
     */
    private Integer timeout;

    /**
     * 缓存时间单位，需要缓存时该值必传
     */
    private TimeUnit timeUnit;

    /**
     * 海报oss缓存key
     */
    private String ossCacheKey;

    /**
     * 海报oss缓存时间
     */
    private Integer ossTimeOut;

    /**
     * 海报oss缓存时间单位
     */
    private TimeUnit ossTimeUnit;
}
