package cn.com.duiba.kjy.api.api.param.material;

import cn.com.duiba.kjy.api.api.dto.wxmessage.innerlog.WxSendEmbedDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/11/5 10:46
 */
@Data
public class MaterialPushParam implements Serializable {

    private static final long serialVersionUID = -5499688568129440596L;

    /**
     * 链接
     */
    @NotBlank
    private String url;

    /**
     * 素材类型，暂不支持视频
     * @see cn.com.duiba.kjy.api.api.enums.WechatMaterialTypeEnum
     */
    @NotNull
    private String type;

    /**
     * 需要推送的oaId
     **/
    private Long oaId;

    /**
     * 需要推送的公众号目标类型，目前只支持公众号和小程序
     * @see cn.com.duiba.kjy.api.api.enums.OaTargetEnum
     */
    private Integer oaTargetType;

    /**
     * 用户微信openId
     */
    @NotBlank
    private String openId;

    /**
     * 推送埋点
     */
    @NotNull
    private WxSendEmbedDto wxSendEmbedDto;

}
