package cn.com.duiba.kjy.api.api.param.tag;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 给用户打标签（如果原来已有则取消原来的再打标签）
 * @author lizhi
 * @date 2020/10/14 6:18 PM
 */
@Data
public class UserTaggingParam implements Serializable {

    private static final long serialVersionUID = -604077816236049477L;

    /**
     * 公众号Id
     */
    @NotNull(message = "公众号ID不能为空")
    private Long oaId;

    /**
     * 微信标签ID
     */
    @NotBlank(message = "标签id不能为空")
    private String wxTagId;

    /**
     * 用户openId
     */
    @NotBlank(message = "用户openId不能为空")
    private String openId;
}
