package cn.com.duiba.kjy.api.api.remoteservice.qrcode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.qrcode.MpQrcodeBatchBindResultDto;
import cn.com.duiba.kjy.api.api.dto.qrcode.MpQrcodeSimpleDto;
import cn.com.duiba.kjy.api.api.param.MpQrCodeBatchBindParam;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2020/9/19 11:41 下午
 **/
@AdvancedFeignClient
public interface RemoteMpQrcodeService {
    /**
     * 根据oaType批量创建小程序码 创建成功后将码加载进redis list中，使用码时直接操作redis即可
     * redisKey {@link cn.com.duiba.kjy.bean.MpQrcodeRedisKeyFactory}
     * value {@link cn.com.duiba.kjy.api.api.dto.qrcode.MpQrcodeSimpleDto}
     *
     * @param oaType 小程序主体类型 {@link cn.com.duiba.kjy.api.api.enums.OATypeEnum}
     * @deprecated 请使用#batchCreateMpQrcodeByOaId
     */
    @Deprecated
    void batchCreateMpQrcodeByOaType(Integer oaType);

    /**
     * 绑定小程序微信二维码 返回小程序码地址
     * @param oaType 小程序主体类型 {@link cn.com.duiba.kjy.api.api.enums.OATypeEnum}
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务key
     * @param scene 场景值
     * @return 小程序二维码url地址
     * @deprecated 请使用#bindMpQrCodeByOaId
     */
    @Deprecated
    String bindMpQrCode(Integer oaType, Integer bizType, String bizKey, String scene);

    /**
     * 绑定小程序微信二维码 返回小程序码地址和id
     *
     * @param oaType 小程序主体类型 {@link cn.com.duiba.kjy.api.api.enums.OATypeEnum}
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务key
     * @param scene 场景值
     * @return 小程序二维码
     * @deprecated 请使用#bindMpQrCodeGetDtoByOaId
     */
    @Deprecated
    MpQrcodeSimpleDto bindMpQrCodeGetDto(Integer oaType, Integer bizType, String bizKey, String scene);

    /**
     * 批量绑定小程序二维码，建议一次处理不超过30条，
     * 没有重试，由业务方自己实现降级方案
     * @param param 绑定参数
     * @return 绑定结果
     * @deprecated 请使用 #batchBindByOaId
     */
    @Deprecated
    List<MpQrcodeBatchBindResultDto> batchBind(MpQrCodeBatchBindParam param);

    /************************* oaId改造 *************************/

    /**
     * 根据oaType批量创建小程序码 创建成功后将码加载进redis list中，使用码时直接操作redis即可
     * redisKey {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeRedisKeyFactory}
     * value {@link cn.com.duiba.kjy.api.api.dto.qrcode.MpQrcodeSimpleDto}
     *
     * @param oaId 小程序主体Id
     */
    void batchCreateMpQrcodeByOaId(Long oaId);

    /**
     * 绑定小程序微信二维码
     * @param oaId 小程序主体ia
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务key
     * @param scene 场景值
     * @return 小程序二维码url地址
     */
    String bindMpQrCodeByOaId(Long oaId, Integer bizType, String bizKey, String scene);

    /**
     * 绑定小程序微信二维码 返回小程序码地址和id
     *
     * @param oaId 小程序主体id
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务key
     * @param scene 场景值
     * @return 小程序二维码
     */
    MpQrcodeSimpleDto bindMpQrCodeGetDtoByOaId(Long oaId, Integer bizType, String bizKey, String scene);

    /**
     * 批量绑定小程序二维码，批量数量最好小于30
     * 没有重试，由业务方自己实现降级方案
     * @param param 绑定参数
     * @return 绑定结果
     */
    List<MpQrcodeBatchBindResultDto> batchBindByOaId(MpQrCodeBatchBindParam param);
}
