package cn.com.duiba.kjy.api.api.remoteservice.qrcode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.qrcode.OaQrcodeResultDto;
import cn.com.duiba.kjy.api.api.enums.OaQrCodeTypeEnum;

/**
 * <p>生成公众号带参数二维码<br/>
 * 临时二维码： 二维码只能在有效期内使用。有效期：自生成时开始的30天内。<br/>
 * 永久二维码： 永久有效。但单个公众号最多只能生成10万个(暂不开放)<br/>
 * 整型：二维码附加参数为整型。 注意：在notify接口进行妥善处理。<br/>
 * 字符串类型：二维码附加参数为字符串。 注意：在notify接口进行妥善处理。<br/>
 * 详情： https://developers.weixin.qq.com/doc/offiaccount/Account_Management/Generating_a_Parametric_QR_Code.html
 * </p>
 * @author dugq
 * @date 2020/11/16 3:05 下午
 *
 */
@AdvancedFeignClient
public interface RemoteWechatOaQrcodeService {

    /**
     * 客集集生成的第三方授权公众号的二维码中，参数固定前缀。
     */
    String KJJ_COMPONENT_QRCODE_MARK = "#KJJ#";

    /**
     * 生成公众号临时整型二维码
     * @param oaId 公众号ID not null
     * @param sceneId 场景值ID。（用户扫码后的回调参数）（0，{@link Integer#MAX_VALUE}]
     * @return 二维码信息
     */
    OaQrcodeResultDto generateOaTempIntQrCode(Long oaId, Integer sceneId);

    /**
     * 生成公众号临时字符串二维码
     * @param oaId 公众号ID not null
     * @param sceneStr 场景值（用户扫码后的回调参数） 非空字符串，最大长度64
     * @return 二维码信息
     */
    OaQrcodeResultDto generateOaTempStringQrCode(Long oaId, String sceneStr);

    /**
     * 生成授权第三方开放平台的公众号的带参数二维码
     * @param oaId 授权第三方开放平台的公众号的oaID。tb_official_account表的主键
     * @param value 自定以附加的额外参数,通过短链服务存储，长度:256。根据type在kjy-web kjy/notify/{appId}/msg接口中进行相对应的处理。
     * @param type kjy-web结构中根据type自定义处理器。{@link OaQrCodeTypeEnum}
     * @return 二维码
     */
    OaQrcodeResultDto generateComponentOaTempStringQrCode(Long oaId,Integer type,String value);
}
