package cn.com.duiba.kjy.api.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.user.WxSubscriberUserBean;
import cn.com.duiba.kjy.api.api.dto.user.WxSubscriberUserDto;

import javax.annotation.Nullable;
import java.util.List;

/**
 * 关注用户rpc服务接口
 *
 * @author 吴文哲
 * @date 2020-06-29 16:26
 **/
@AdvancedFeignClient
public interface RemoteSubscriberUserService {


    /**
     * 批量查询公众号关注用户列表 最多一次查100条
     *
     * @param accessToken 公众号的accessToken
     * @param openIdList  公众号下的用户openId列表
     * @return
     * @deprecated accessToken的调用权限即将回收
     */
    @Deprecated
    List<WxSubscriberUserBean> getWxSubscriberUserList(String accessToken, List<String> openIdList);

    /**
     * 批量查询公众号关注用户列表 最多一次查100条
     *
     * @param oaId 公众号ID
     * @param openIdList  公众号下的用户openId列表
     * @return
     */
    List<WxSubscriberUserDto> getOaSubscriberUserList(Long oaId, List<String> openIdList);

    /**
     * 查询单个用户的用户信息
     * @param oaId 公众号ID（已关注）
     * @param openId 微信用户加密ID
     * @return 用户信息。 null:查询失败
     */
    @Nullable
    WxSubscriberUserDto getWxSubscriberUser(Long oaId, String openId);
}
